*___________________________________________________________________________________________________

	VECM 02.sas

	Estimate a VECM for real data (MTZ, October, 2005)

	This program uses the following macros (in the '/SAS macros' subdirectory):
	qBuild, VECM2, VarianceDecomp

____________________________________________________________________________________________________;

*	Modify the following statement to set current directory to location of program;
x 'cd c:\Active\EMM Distribution\SAS Programs v0100';
options nodate nocenter nonumber ps=70 ls=120  sasautos=('./Sas Macros','.') nomprint; 
libname SASData '.\Datasets';

ods pdf file='./VECM 02.pdf' style=serifPrinter;

title 'VECM 02.sas';

proc print data=SASData.cq (where=(time>='9:30't) obs=30);
title 'VECM 02.sas: Original cq data';
run;


*	The following call creates a parallel quote record for all exchanges;
%qbuild(dsIn=SASData.cq, dsOut=cqAll, timeBase=minute5);
proc print data=cqAll (obs=30) noobs;
	by symbol date;
	title 'VECM 02.sas: Parallel quotes, every five minutes.';
	run;
proc means data=cqAll;
run;

title "NYSE versus P; Quotes sampled every five minutes; VECM order=3";
%VECM2(dsIn=cqAll, model=Nbid Nofr Pbid Pofr,  order=3, nImpulse=30, PrintLevel=1);
%VarianceDecomp(dsCov=covInnovation, dsCoeff=LRCoeff, RowLabel=Variable);
%VarianceDecomp(dsCov=covInnovation, dsCoeff=LRCoeff, RowLabel=Variable, Perm=Nofr Nbid Pbid Pofr);
%VarianceDecomp(dsCov=covInnovation, dsCoeff=LRCoeff, RowLabel=Variable, Perm=Pbid Pofr Nbid Nofr);

%qbuild(dsIn=SASData.cq, dsOut=cqAll, timeBase=second5);
proc print data=cqAll (obs=30) noobs;
	by symbol date;
	title 'VECM 02.sas: Parallel quotes, every five seconds.';
	run;
proc means data=cqAll;
title "NYSE versus P; Quotes sampled every five seconds; VECM order=12";
%VECM2(dsIn=cqAll, model=Nbid Nofr Pbid Pofr,  order=12, nImpulse=1000, PrintLevel=1);
%VarianceDecomp(dsCov=covInnovation, dsCoeff=LRCoeff, RowLabel=Variable);
%VarianceDecomp(dsCov=covInnovation, dsCoeff=LRCoeff, RowLabel=Variable, Perm=Pbid Pofr Nbid Nofr);

ods _all_ close;


